﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Messaging

Public Class MainForm

    Private m_Path As String = ".\private$\orders"

    ' 开始从队列读取消息。
    Private Sub HookQueue()
        Try
            ' 当我们停止时。
            If qOrders Is Nothing Then
                qOrders = New System.Messaging.MessageQueue(m_Path)
            End If

            ' 开始等待消息到达。
            qOrders.BeginReceive()

        Catch exp As MessageQueueException
            My.Application.Log.WriteEntry(exp.Message)
        Catch exp As Exception
            My.Application.Log.WriteEntry(exp.Message)
        End Try
    End Sub

    ' 停止从队列读取消息。
    Private Sub UnhookQueue()
        Try
            qOrders.Close()
        Catch exp As Exception
            My.Application.Log.WriteEntry(exp.Message)
        End Try
    End Sub

    ' 消息已接收事件的事件处理程序。
    Private Sub qOrders_ReceiveCompleted(ByVal sender As Object, ByVal e As System.Messaging.ReceiveCompletedEventArgs) Handles qOrders.ReceiveCompleted
        Try
            ' 获取消息。
            Dim m As Message
            m = qOrders.EndReceive(e.AsyncResult)

            ' 将消息添加到 Listbox。
            OrderListbox.Items.Add(m.Label)

            ' 现在继续侦听消息。
            qOrders.BeginReceive()

        Catch exp As MessageQueueException
            My.Application.Log.WriteEntry(exp.Message)
        Catch exp As Exception
            My.Application.Log.WriteEntry(exp.Message)
        End Try
    End Sub

    ' 清除 Listbox。
    Private Sub ClearButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearButton.Click
        OrderListbox.Items.Clear()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' 如果专用队列不存在，则创建专用队列。
        Try
            If Not MessageQueue.Exists(".\private$\orders") Then
                MessageQueue.Create(".\private$\orders")
            End If
        Catch ex As Exception

        End Try
    End Sub



    ' 切换消息侦听。
    Private Sub Listen_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Listen.CheckedChanged
        If Listen.Checked Then
            Try
                HookQueue()
            Catch exp As MessageQueueException
                My.Application.Log.WriteEntry(exp.Message)
            Catch exp As Exception
                My.Application.Log.WriteEntry(exp.Message)
            End Try
        Else
            UnhookQueue()
        End If
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub
End Class
